/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.content.logistics.packagePort.postbox.PostboxBlockEntity;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.TextScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalPackagePort;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import net.createmod.catnip.data.Glob;
import net.createmod.catnip.data.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_342;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;

public class FetchPackagesInstruction
extends TextScheduleInstruction {
    @Override
    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)this.getSecondLineIcon(), (Object)CreateLang.translateDirect("schedule.instruction.package_retrieval", new Object[0]));
    }

    @Override
    public List<class_2561> getTitleAs(String type) {
        return ImmutableList.of((Object)CreateLang.translate("schedule.instruction.package_retrieval.summary", new Object[0]).style(class_124.field_1065).component(), (Object)CreateLang.translateDirect("generic.in_quotes", class_2561.method_43470((String)this.getLabelText())), (Object)CreateLang.translateDirect("schedule.instruction.package_retrieval.summary_1", new Object[0]).method_27692(class_124.field_1080), (Object)CreateLang.translateDirect("schedule.instruction.package_retrieval.summary_2", new Object[0]).method_27692(class_124.field_1080));
    }

    @Override
    public class_1799 getSecondLineIcon() {
        return PackageStyles.getDefaultBox();
    }

    public String getFilter() {
        return this.getLabelText();
    }

    public String getFilterForRegex() {
        if (this.getFilter().isBlank()) {
            return Glob.toRegexPattern((String)"*", (String)"");
        }
        return Glob.toRegexPattern((String)this.getFilter(), (String)"");
    }

    @Override
    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.instruction.address_filter_edit_box", new Object[0]), (Object)CreateLang.translateDirect("schedule.instruction.address_filter_edit_box_1", new Object[0]).method_27692(class_124.field_1080), (Object)CreateLang.translateDirect("schedule.instruction.address_filter_edit_box_2", new Object[0]).method_27692(class_124.field_1063), (Object)CreateLang.translateDirect("schedule.instruction.address_filter_edit_box_3", new Object[0]).method_27692(class_124.field_1063));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void modifyEditBox(class_342 box) {
        box.method_1890(s -> StringUtils.countMatches((CharSequence)s, (char)'*') <= 3);
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("package_retrieval");
    }

    @Override
    public boolean supportsConditions() {
        return true;
    }

    @Override
    public DiscoveredPath start(ScheduleRuntime runtime, class_1937 level) {
        MinecraftServer server = level.method_8503();
        if (server == null) {
            return null;
        }
        String regex = this.getFilterForRegex();
        boolean anyMatch = false;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        Train train = runtime.train;
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            runtime.startCooldown();
            return null;
        }
        for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
            class_3218 dimLevel = server.method_3847(globalStation.blockEntityDimension);
            if (dimLevel == null) continue;
            for (Map.Entry<class_2338, GlobalPackagePort> entry : globalStation.connectedPorts.entrySet()) {
                class_2586 class_25862;
                GlobalPackagePort port = entry.getValue();
                class_2338 pos = entry.getKey();
                Object postboxInventory = port.offlineBuffer;
                if (dimLevel.method_8477(pos) && (class_25862 = dimLevel.method_8321(pos)) instanceof PostboxBlockEntity) {
                    PostboxBlockEntity ppbe = (PostboxBlockEntity)class_25862;
                    postboxInventory = ppbe.inventory;
                }
                for (int slot = 0; slot < postboxInventory.getSlotCount(); ++slot) {
                    class_1799 stack = postboxInventory.getStackInSlot(slot);
                    if (!PackageItem.isPackage(stack) || PackageItem.matchAddress(stack, port.address)) continue;
                    try {
                        if (!PackageItem.getAddress(stack).matches(regex)) continue;
                        anyMatch = true;
                        validStations.add(globalStation);
                        continue;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
        if (validStations.isEmpty()) {
            runtime.startCooldown();
            runtime.state = ScheduleRuntime.State.PRE_TRANSIT;
            ++runtime.currentEntry;
            return null;
        }
        DiscoveredPath best = train.navigation.findPathTo(validStations, Double.MAX_VALUE);
        if (best == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            }
            runtime.startCooldown();
            return null;
        }
        return best;
    }
}

